import LogUtil from "~/server/utils/log"
import path from 'path'

export default defineEventHandler(async (event) => {
  let username = event.context.username
   try {
    let docker = createDockerFactory(username)
    LogUtil.clear(username)

    await changeProjectStatus('v1', username, 'status', 'compiling')
    const rowV2 = await getPgTableData('v2', username)
    if (rowV2?.status === 'launched') {
      await changeProjectStatus('v2', username, 'status', 'compiled')
    }
    // 每次编译前把已有的 tenants_config 文件夹拷贝到一个地方，编译完成后，再拷贝回来

    let container = await docker.checkContainer( username + '.node')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }
    await docker.startContainer({ container })

    await docker.preStartSystem({ container, username, platform: 'v1' })
    LogUtil.printInfo(username, '编译中')
    const pomDir = '/var/logwire-platform/logwire-build/logwire-server/logwire-libs/logwire-web'
    await docker.putArchive({ container, tarPath: path.resolve('./public/files/v1/pomWithoutWeb.tar'), targetPath: pomDir })
    await docker.execContainerCommand({ container, cmd: ['/bin/bash', '-c', 'export LANG=zh_CN.UTF-8;mvn clean package -Dmaven.test.skip=true'], dir: '/var/logwire-platform/logwire-build'})
    await docker.putArchive({ container, tarPath: path.resolve('./public/files/v1/pomWithWeb.tar'), targetPath: pomDir })

    const pomVersionStr = await docker.getFile({ container, path: '/var/logwire-platform/logwire-build/logwire-version/pom.xml' })
    const version = /<logwire-starter\.version>(.*?)<\/logwire-starter\.version>/.exec(pomVersionStr)?.[1]
    const versionWeb = /<logwire-libs\.version>(.*?)<\/logwire-libs\.version>/.exec(pomVersionStr)?.[1]

    await docker.execContainerCommand({ container, cmd: 'tar -zvcf ../tenants.tar.gz ./projects/demo', dir: '/var/logwire-platform/dist'})
    await docker.execContainerCommand({ container, cmd: 'rm -rf dist', dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: 'mkdir -p dist/lib', dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: 'mkdir -p dist/config', dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: 'mkdir -p dist/products', dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: `cp logwire-build/logwire-server/logwire-starter/target/logwire-starter-${version}.jar dist/`, dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: `cp logwire-build/logwire-server/logwire-libs/logwire-web/target/logwire-web-${versionWeb}.jar dist/lib/`, dir: '/var/logwire-platform'})
    await docker.execContainerCommand({ container, cmd: 'tar -zxvf ../tenants.tar.gz', dir: '/var/logwire-platform/dist'})
    await docker.execContainerCommand({ container, cmd: 'rm ../tenants.tar.gz', dir: '/var/logwire-platform/dist'})
    await copyAndCreateServerPropertiesV1InDocker(username)
    LogUtil.printInfo(username, '编译完成')
    await changeProjectStatus( 'v1', username, 'status', 'compiled')
  } catch (err) {
    await changeProjectStatus( 'v1', username, 'status', 'created')
    LogUtil.printError(username, err instanceof Error ? err.message : JSON.stringify(err))
    setResponseStatus(event, 500)
    return err
  }
})