import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  try {
    LogUtil.clear(username)
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer( username + '.node')
    const row = await getPgTableData( 'user', username)
    const port = row?.["port"]

    LogUtil.printInfo(username, '程序启动中')
    await changeProjectStatus( 'v1', username, 'status', 'running')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }

    // 读取 pom.xml
    const pomVersionStr = await docker.getFile({ container, path: '/var/logwire-platform/logwire-build/logwire-version/pom.xml' })
    const version = /<logwire-starter\.version>(.*?)<\/logwire-starter\.version>/.exec(pomVersionStr)?.[1]
    const versionWeb = /<logwire-libs\.version>(.*?)<\/logwire-libs\.version>/.exec(pomVersionStr)?.[1]

    await docker.preStartSystem({ container, username, platform: 'v1' })
    await docker.execContainerCommand({ container, cmd: `pm2 start --name platform --no-autorestart java -- -Xms512m -Xmx512m -XX:MaxMetaspaceSize=200m -Dfile.encoding=UTF-8 -Dloader.path=lib -jar logwire-starter-${version}.jar > logwire.log`, dir: '/var/logwire-platform/dist', quiet: true })

    LogUtil.print(username, `[progress] [[1;34mInfo[m] 程序运行中...... \n`)
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 请代理后端请求到 <strong>${HOST}:${port}</strong> 上 \n`)
    await changeProjectStatus( 'v1', username, 'status', 'launched')
  } catch (err) {
    await changeProjectStatus( 'v2', username, 'status', 'compiled')
    LogUtil.print(username, '[error] [[1;31mError[m]] ' + (err instanceof Error ? err.message : JSON.stringify(err)))
    setResponseStatus(event, 500)
  }
})