import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  LogUtil.clear(username)
  let docker = createDockerFactory(username)
  let container = await docker.checkContainer( username + '.node')
  if (!container) {
    throw new Error('没有创建容器，请先初始化容器')
  }
  LogUtil.printInfo(username, `程序停止中......`)
  await changeProjectStatus( 'v1', username, 'status', 'stopping')
  await docker.execContainerCommand({ container, cmd: 'pm2 delete platform', quiet: true })
  LogUtil.printInfo(username, `程序已停止`)
  await changeProjectStatus( 'v1', username, 'status', 'compiled')
})