import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  // 先判断服务是否启动，启动则关闭，然后调用新的命令启动 java 端
    let username = event.context.username
    LogUtil.clear(username)
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer( username + '.node')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }
    const rowV2 = await getPgTableData( 'v2', username)
    const tenants = rowV2!.tenants
    const rowUser = await getPgTableData( 'user', username)
    const port = rowUser!.port
    const debug = rowV2!.debug

    if (rowV2?.status !== 'compiled') {
      throw new Error('调试只可以在已创建状态下进行')
    }

    await changeProjectStatus( 'v2', username, 'status', 'running')
    // 有可能本身就关闭了
    try {
      LogUtil.print(username, `[progress] [[1;34mLoading[m] 关闭已存在的 Nginx 服务 ...... \n`)
      await docker.execContainerCommand({ container, cmd: 'nginx -s stop'})
    } catch (err) {}

    await LogUtil.run(username, '初始化调试功能', async () => {
      if (rowV2?.has_debugged) return
      try {
        if (container) {
          LogUtil.print(username, `[progress] [Loading] 下载 Nginx ...... \n`)
          await docker.execContainerCommand({ container, cmd: 'curl -O https://nginx.org/download/nginx-1.18.0.tar.gz', dir: '/var/tmp' })
          LogUtil.print(username, `[progress] [Loading] 解压 Nginx ...... \n`)
          await docker.execContainerCommand({ container, cmd: 'tar -xvzf nginx-1.18.0.tar.gz', dir: '/var/tmp'})
          LogUtil.print(username, `[progress] [Loading] 配置 Nginx ...... \n`)
          await docker.execContainerCommand({ container, cmd: './configure --prefix=/usr/share/nginx/ --conf-path=/etc/nginx/nginx.conf --http-log-path=/var/log/nginx/access.log --error-log-path=/var/log/nginx/error.log --lock-path=/var/lock/nginx.lock --pid-path=/run/nginx.pid --modules-path=/usr/lib/nginx/modules --http-client-body-temp-path=/var/lib/nginx/body --http-fastcgi-temp-path=/var/lib/nginx/fastcgi --http-proxy-temp-path=/var/lib/nginx/proxy --http-scgi-temp-path=/var/lib/nginx/scgi --http-uwsgi-temp-path=/var/lib/nginx/uwsgi --with-compat --with-debug --with-pcre-jit --with-http_ssl_module --with-http_stub_status_module --with-http_realip_module --with-http_auth_request_module --with-http_v2_module --with-http_dav_module --with-http_slice_module --with-threads --with-http_addition_module --with-http_gunzip_module --with-http_gzip_static_module --with-http_sub_module --with-stream=dynamic', dir: '/var/tmp/nginx-1.18.0' })
          
          LogUtil.print(username, `[progress] [Loading] 编译 Nginx ...... \n`)
          await docker.execContainerCommand({ container, cmd: 'make', dir: '/var/tmp/nginx-1.18.0'})
          LogUtil.print(username, `[progress] [Loading] 替换 Nginx 文件 ...... \n`)
          await docker.execContainerCommand({ container, cmd: 'cp /var/tmp/nginx-1.18.0/objs/nginx /usr/sbin/'})

          await setPgTableData( 'v2', username, 'has_debugged', true)
        }
      } catch (err) {
        console.log('err2', err)
        throw err
      }
    })
    LogUtil.print(username, `[progress] [[1;34mLoading[m] 替换 Nginx 配置 ...... \n`)
    await copyAndCreateNginxConfInDocker(username)
    LogUtil.print(username, `[progress] [[1;34mLoading[m] 启动 Nginx ...... \n`)
    await docker.execContainerCommand({ container, cmd: 'nginx'})
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 程序启动中...... \n`)
    try {
      await docker.execContainerCommand({ container, cmd: 'pm2 delete backend' })
      await docker.execContainerCommand({ container, cmd: 'pm2 delete gateway' })
    } catch (err) {
    }

    await docker.execContainerCommand({ container, cmd: 'pm2 start --name gateway --no-autorestart java -- -Xms128m -Xmx128m -XX:+UseG1GC --add-opens java.base/sun.util.locale.provider=ALL-UNNAMED -jar logwire-gateway-starter.jar', dir: '/var/logwire-backend/build-output/gateway', quiet: true })
    await docker.execContainerCommand({ container, cmd: 'pm2 start --name backend --no-autorestart java -- -Xms128m -Xmx128m -XX:+UseG1GC -DVALIDATE_XML_ENABLED=false --add-opens java.base/sun.util.locale.provider=ALL-UNNAMED -Xdebug -Xrunjdwp:server=y,transport=dt_socket,address=:6666,suspend=n -jar logwire-backend-starter.jar', dir: '/var/logwire-backend/build-output/backend', quiet: true })

    LogUtil.print(username, `[progress] [[1;34mInfo[m] 程序运行中...... \n`)
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 请代理后端请求到 <strong>${HOST}:${port}</strong> 上 \n`)
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 请设置开发环境域名和端口号 <strong>${tenants?.host}</strong> 上\n`)
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 调试程序已启动，请IP地址为 <strong>${debug?.host}</strong> 后端访问 <strong>${HOST}:${port}</strong> 进行调试\n`)

    await changeProjectStatus( 'v2', username, 'status', 'debug-launched')
})