import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  LogUtil.clear(username)
  let docker = createDockerFactory(username)
  // 创建 node 容器
  let container = await docker.checkContainer( username + '.node')
  let row = await getPgTableData( 'user', username)
  let port = row?.["port"]
  if (container) {
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 打包微信小程序zip \n`)
    await docker.execContainerCommand({ container, cmd: 'rm -f weapp.zip', dir: '/var/logwire-backend/build-output/backend' })
    await docker.execContainerCommand({ container, cmd: `zip -q -r weapp.zip miniapp/main/dist miniapp/main/src/pages miniapp/main/src/app.config.ts`, dir: '/var/logwire-backend/build-output/backend' })
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 打包结束，访问 <a target="_blank" href="http://${HOST}:${port}/download/backend/">http://${HOST}:${port}/download/backend/</a> 下载 webapp.zip 文件 \n`)
  } else {
    throw new Error('没有创建容器，请先初始化容器')
  }
})