import { V2 as TableV2 } from "~/typings/__generated__/resolvers-types"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  let docker = createDockerFactory(username)
  const row = await getPgTableData( 'v2', username)
  const info: Partial<TableV2> & { branch: string } = { ...row, branch: '' }
  info.status = row?.status || 'null'
  try {
    let container = await docker.checkContainer(username + '.node')
    if (container) {
      await docker.startContainer({ container })
      let result = await docker.execContainerCommand({ container, cmd: 'git branch', dir: getPlatformRootFolder('v2') })
      const arrays = result.split('\n')
      let currentBranch = arrays.find(o => o.includes('*'))
      currentBranch = currentBranch?.replace(/^.*?\*/, '').trim() || ''
      info.branch = removeUnreadCharacter(currentBranch)
    } else {
      info.branch = '无'
    }
  } catch (err) {
    // 出现任何错误都认为没有未初始化分支
    info.branch = '无'
  }
  return info
})