import { getPlatformRootFolder } from "~/server/utils/server"

export default defineEventHandler(async (event) => {
  const body = await readBody(event)
  let username = event.context.username
  let docker = createDockerFactory(username)
  let branch = body.branch
  let container = await docker.checkContainer( username + '.node')
  const dir = getPlatformRootFolder(body.platform)
  if (container) {
    await docker.startContainer({ container })
    await docker.execContainerCommand({ container, cmd: 'git fetch', dir })
    // fetch 时有可能本分支被强推了
    if (branch === 'master') {
      await docker.execContainerCommand({ container, cmd: 'git pull', dir })
    } else {
      await docker.execContainerCommand({ container, cmd: 'git checkout master', dir })
      await docker.execContainerCommand({ container, cmd: 'git branch -D ' + branch, dir })
      await docker.execContainerCommand({ container, cmd: 'git checkout ' + branch, dir })
    }
  } else {
    throw new Error('没有创建容器，请先初始化容器')
  }
})