import pg from 'pg'
import { sendProjectStatus } from './log'
import { User as TableUser, V2 as TableV2, V1 as TableV1 } from '~/typings/__generated__/resolvers-types'

const config = useRuntimeConfig()

export const PgPort = config.pgPort
export const PgHost = config.pgHost

let pool: pg.Pool = new pg.Pool({
  host: PgHost,
  port: Number(PgPort),
  database: 'backend_helper',
  user: config.pgUser,
  password: config.pgPassword
})

export async function createPgClient (payload: {
  user?: string
  password?: string
  database?: string
  host?: string
  port?: number
}) {
  let client = new pg.Client({
    user: payload.user || config.pgUser,
    password: payload.password || config.pgPassword,
    database: payload.database || config.pgDatabase,
    host: payload.host || config.pgHost,
    port: payload.port || Number(config.pgPort)
  })
  await client.connect()
  return client
}

export function executePgQuery ({ client, query }: { client: pg.Client, query: string }) {
  return client.query(query)
}
export function createPgClientFactory (database?: string) {
  return createPgClient({ database })
}
export function stopPgClient (pgClient: pg.Client) {
  return pgClient.end()
}

export async function getPgTableData (table: 'v1', username: string): Promise<TableV1>;
export async function getPgTableData (table: 'v2', username: string): Promise<TableV2>;
export async function getPgTableData (table: 'user', username: string): Promise<TableUser>;
export async function getPgTableData (table: string, username: string) {
  const result = await pool.query(`select * from public.${table} where username = '${username}'`)
  return result.rows[0]
}

export async function setPgTableData (table: 'user', username: string, key: keyof TableUser, value: TableUser[keyof TableUser]): Promise<void>;
export async function setPgTableData (table: 'v2', username: string, key: keyof TableV2, value: TableV2[keyof TableV2]): Promise<void>;
export async function setPgTableData (table: 'v1', username: string, key: keyof TableV1, value: TableV1[keyof TableV1]): Promise<void>;
export async function setPgTableData (table: 'v1' | 'v2' | 'user', username: string, key: string, value: any) {
  await pool.query(`UPDATE public.${table} SET "${key}"='${value}' WHERE username='${username}'`)
}

export async function insertPgTableData (table: 'v1', username: string): Promise<void>;
export async function insertPgTableData (table: 'v2', username: string): Promise<undefined>;
export async function insertPgTableData (table: 'user', username: string): Promise<undefined>;
export async function insertPgTableData (table: string, username: string) {
  await pool.query(`INSERT INTO public."${table}"(username) VALUES ('${username}');`)
}

export async function changeProjectStatus (table: 'v2', username: string, key: keyof TableV2, value: TableV2[keyof TableV2]): Promise<void>;
export async function changeProjectStatus (table: 'v1', username: string, key: keyof TableV1, value: TableV1[keyof TableV1]): Promise<void>;
export async function changeProjectStatus (table: string, username: string, key: string, value: any) {
  await setPgTableData(table as any, username, key as any, value)
  sendProjectStatus(table as any, username, value)
}

