import { GraphQLResolveInfo } from 'graphql';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
};

export type Debug = {
  __typename?: 'Debug';
  host?: Maybe<Scalars['String']['output']>;
};

export type Query = {
  __typename?: 'Query';
  user?: Maybe<User>;
  v1?: Maybe<V1>;
  v2?: Maybe<V2>;
};


export type QueryUserArgs = {
  username?: InputMaybe<Scalars['String']['input']>;
};


export type QueryV1Args = {
  username?: InputMaybe<Scalars['String']['input']>;
};


export type QueryV2Args = {
  username?: InputMaybe<Scalars['String']['input']>;
};

export type ServerProperty = {
  __typename?: 'ServerProperty';
  id?: Maybe<Scalars['Float']['output']>;
  key?: Maybe<Scalars['String']['output']>;
  value?: Maybe<Scalars['String']['output']>;
};

export type Tenant = {
  __typename?: 'Tenant';
  databaseschema?: Maybe<Scalars['String']['output']>;
  host?: Maybe<Scalars['String']['output']>;
  id?: Maybe<Scalars['String']['output']>;
  primarynamespace?: Maybe<Scalars['String']['output']>;
};

export type User = {
  __typename?: 'User';
  port?: Maybe<Scalars['Int']['output']>;
  username?: Maybe<Scalars['String']['output']>;
};

export type V1 = {
  __typename?: 'V1';
  branch?: Maybe<Scalars['String']['output']>;
  serverProperties?: Maybe<Array<ServerProperty>>;
  status?: Maybe<Scalars['String']['output']>;
  username?: Maybe<Scalars['String']['output']>;
};

export type V2 = {
  __typename?: 'V2';
  branch?: Maybe<Scalars['String']['output']>;
  debug?: Maybe<Debug>;
  has_debugged?: Maybe<Scalars['Boolean']['output']>;
  serverProperties?: Maybe<Array<ServerProperty>>;
  status?: Maybe<Scalars['String']['output']>;
  tenants?: Maybe<Tenant>;
  username?: Maybe<Scalars['String']['output']>;
};



export type ResolverTypeWrapper<T> = Promise<T> | T;


export type ResolverWithResolve<TResult, TParent, TContext, TArgs> = {
  resolve: ResolverFn<TResult, TParent, TContext, TArgs>;
};
export type Resolver<TResult, TParent = {}, TContext = {}, TArgs = {}> = ResolverFn<TResult, TParent, TContext, TArgs> | ResolverWithResolve<TResult, TParent, TContext, TArgs>;

export type ResolverFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => Promise<TResult> | TResult;

export type SubscriptionSubscribeFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => AsyncIterable<TResult> | Promise<AsyncIterable<TResult>>;

export type SubscriptionResolveFn<TResult, TParent, TContext, TArgs> = (
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;

export interface SubscriptionSubscriberObject<TResult, TKey extends string, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<{ [key in TKey]: TResult }, TParent, TContext, TArgs>;
  resolve?: SubscriptionResolveFn<TResult, { [key in TKey]: TResult }, TContext, TArgs>;
}

export interface SubscriptionResolverObject<TResult, TParent, TContext, TArgs> {
  subscribe: SubscriptionSubscribeFn<any, TParent, TContext, TArgs>;
  resolve: SubscriptionResolveFn<TResult, any, TContext, TArgs>;
}

export type SubscriptionObject<TResult, TKey extends string, TParent, TContext, TArgs> =
  | SubscriptionSubscriberObject<TResult, TKey, TParent, TContext, TArgs>
  | SubscriptionResolverObject<TResult, TParent, TContext, TArgs>;

export type SubscriptionResolver<TResult, TKey extends string, TParent = {}, TContext = {}, TArgs = {}> =
  | ((...args: any[]) => SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>)
  | SubscriptionObject<TResult, TKey, TParent, TContext, TArgs>;

export type TypeResolveFn<TTypes, TParent = {}, TContext = {}> = (
  parent: TParent,
  context: TContext,
  info: GraphQLResolveInfo
) => Maybe<TTypes> | Promise<Maybe<TTypes>>;

export type IsTypeOfResolverFn<T = {}, TContext = {}> = (obj: T, context: TContext, info: GraphQLResolveInfo) => boolean | Promise<boolean>;

export type NextResolverFn<T> = () => Promise<T>;

export type DirectiveResolverFn<TResult = {}, TParent = {}, TContext = {}, TArgs = {}> = (
  next: NextResolverFn<TResult>,
  parent: TParent,
  args: TArgs,
  context: TContext,
  info: GraphQLResolveInfo
) => TResult | Promise<TResult>;



/** Mapping between all available schema types and the resolvers types */
export type ResolversTypes = {
  Boolean: ResolverTypeWrapper<Scalars['Boolean']['output']>;
  Debug: ResolverTypeWrapper<Debug>;
  Float: ResolverTypeWrapper<Scalars['Float']['output']>;
  Int: ResolverTypeWrapper<Scalars['Int']['output']>;
  Query: ResolverTypeWrapper<{}>;
  ServerProperty: ResolverTypeWrapper<ServerProperty>;
  String: ResolverTypeWrapper<Scalars['String']['output']>;
  Tenant: ResolverTypeWrapper<Tenant>;
  User: ResolverTypeWrapper<User>;
  V1: ResolverTypeWrapper<V1>;
  V2: ResolverTypeWrapper<V2>;
};

/** Mapping between all available schema types and the resolvers parents */
export type ResolversParentTypes = {
  Boolean: Scalars['Boolean']['output'];
  Debug: Debug;
  Float: Scalars['Float']['output'];
  Int: Scalars['Int']['output'];
  Query: {};
  ServerProperty: ServerProperty;
  String: Scalars['String']['output'];
  Tenant: Tenant;
  User: User;
  V1: V1;
  V2: V2;
};

export type DebugResolvers<ContextType = any, ParentType extends ResolversParentTypes['Debug'] = ResolversParentTypes['Debug']> = {
  host?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type QueryResolvers<ContextType = any, ParentType extends ResolversParentTypes['Query'] = ResolversParentTypes['Query']> = {
  user?: Resolver<Maybe<ResolversTypes['User']>, ParentType, ContextType, Partial<QueryUserArgs>>;
  v1?: Resolver<Maybe<ResolversTypes['V1']>, ParentType, ContextType, Partial<QueryV1Args>>;
  v2?: Resolver<Maybe<ResolversTypes['V2']>, ParentType, ContextType, Partial<QueryV2Args>>;
};

export type ServerPropertyResolvers<ContextType = any, ParentType extends ResolversParentTypes['ServerProperty'] = ResolversParentTypes['ServerProperty']> = {
  id?: Resolver<Maybe<ResolversTypes['Float']>, ParentType, ContextType>;
  key?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  value?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type TenantResolvers<ContextType = any, ParentType extends ResolversParentTypes['Tenant'] = ResolversParentTypes['Tenant']> = {
  databaseschema?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  host?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  id?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  primarynamespace?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type UserResolvers<ContextType = any, ParentType extends ResolversParentTypes['User'] = ResolversParentTypes['User']> = {
  port?: Resolver<Maybe<ResolversTypes['Int']>, ParentType, ContextType>;
  username?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type V1Resolvers<ContextType = any, ParentType extends ResolversParentTypes['V1'] = ResolversParentTypes['V1']> = {
  branch?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  serverProperties?: Resolver<Maybe<Array<ResolversTypes['ServerProperty']>>, ParentType, ContextType>;
  status?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  username?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type V2Resolvers<ContextType = any, ParentType extends ResolversParentTypes['V2'] = ResolversParentTypes['V2']> = {
  branch?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  debug?: Resolver<Maybe<ResolversTypes['Debug']>, ParentType, ContextType>;
  has_debugged?: Resolver<Maybe<ResolversTypes['Boolean']>, ParentType, ContextType>;
  serverProperties?: Resolver<Maybe<Array<ResolversTypes['ServerProperty']>>, ParentType, ContextType>;
  status?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  tenants?: Resolver<Maybe<ResolversTypes['Tenant']>, ParentType, ContextType>;
  username?: Resolver<Maybe<ResolversTypes['String']>, ParentType, ContextType>;
  __isTypeOf?: IsTypeOfResolverFn<ParentType, ContextType>;
};

export type Resolvers<ContextType = any> = {
  Debug?: DebugResolvers<ContextType>;
  Query?: QueryResolvers<ContextType>;
  ServerProperty?: ServerPropertyResolvers<ContextType>;
  Tenant?: TenantResolvers<ContextType>;
  User?: UserResolvers<ContextType>;
  V1?: V1Resolvers<ContextType>;
  V2?: V2Resolvers<ContextType>;
};

